// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Marketplace.Models
{
    /// <summary> The PrivateStorePlan. </summary>
    public partial class PrivateStorePlan
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PrivateStorePlan"/>. </summary>
        public PrivateStorePlan()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PrivateStorePlan"/>. </summary>
        /// <param name="skuId"> Identifier for this plan. </param>
        /// <param name="planId"> Text identifier for this plan. </param>
        /// <param name="planDisplayName"> Friendly name for the plan for display in the marketplace. </param>
        /// <param name="accessibility"> Plan accessibility. </param>
        /// <param name="altStackReference"> Alternative stack type. </param>
        /// <param name="stackType"> Stack type (classic or arm). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PrivateStorePlan(string skuId, string planId, string planDisplayName, PrivateStorePlanAccessibility? accessibility, string altStackReference, string stackType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SkuId = skuId;
            PlanId = planId;
            PlanDisplayName = planDisplayName;
            Accessibility = accessibility;
            AltStackReference = altStackReference;
            StackType = stackType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Identifier for this plan. </summary>
        public string SkuId { get; }
        /// <summary> Text identifier for this plan. </summary>
        public string PlanId { get; }
        /// <summary> Friendly name for the plan for display in the marketplace. </summary>
        public string PlanDisplayName { get; }
        /// <summary> Plan accessibility. </summary>
        public PrivateStorePlanAccessibility? Accessibility { get; set; }
        /// <summary> Alternative stack type. </summary>
        public string AltStackReference { get; }
        /// <summary> Stack type (classic or arm). </summary>
        public string StackType { get; }
    }
}
