// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Marketplace.Models
{
    /// <summary> Set the Operation for the POST method. Ping or Delete. </summary>
    public readonly partial struct PrivateStoreOperation : IEquatable<PrivateStoreOperation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PrivateStoreOperation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PrivateStoreOperation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeletePrivateStoreOfferValue = "DeletePrivateStoreOffer";
        private const string DeletePrivateStoreCollectionValue = "DeletePrivateStoreCollection";
        private const string DeletePrivateStoreCollectionOfferValue = "DeletePrivateStoreCollectionOffer";
        private const string PingValue = "Ping";

        /// <summary> DeletePrivateStoreOffer. </summary>
        public static PrivateStoreOperation DeletePrivateStoreOffer { get; } = new PrivateStoreOperation(DeletePrivateStoreOfferValue);
        /// <summary> DeletePrivateStoreCollection. </summary>
        public static PrivateStoreOperation DeletePrivateStoreCollection { get; } = new PrivateStoreOperation(DeletePrivateStoreCollectionValue);
        /// <summary> DeletePrivateStoreCollectionOffer. </summary>
        public static PrivateStoreOperation DeletePrivateStoreCollectionOffer { get; } = new PrivateStoreOperation(DeletePrivateStoreCollectionOfferValue);
        /// <summary> Ping. </summary>
        public static PrivateStoreOperation Ping { get; } = new PrivateStoreOperation(PingValue);
        /// <summary> Determines if two <see cref="PrivateStoreOperation"/> values are the same. </summary>
        public static bool operator ==(PrivateStoreOperation left, PrivateStoreOperation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PrivateStoreOperation"/> values are not the same. </summary>
        public static bool operator !=(PrivateStoreOperation left, PrivateStoreOperation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PrivateStoreOperation"/>. </summary>
        public static implicit operator PrivateStoreOperation(string value) => new PrivateStoreOperation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PrivateStoreOperation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PrivateStoreOperation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
