// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Marketplace.Models
{
    /// <summary> user request details. </summary>
    public partial class PlanRequesterInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PlanRequesterInfo"/>. </summary>
        internal PlanRequesterInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PlanRequesterInfo"/>. </summary>
        /// <param name="user"> Gets user id. </param>
        /// <param name="date"> Gets request date. </param>
        /// <param name="justification"> Gets justification. </param>
        /// <param name="subscriptionId"> Gets the subscription id that the user is requesting to add the plan to. </param>
        /// <param name="subscriptionName"> Gets the subscription name that the user is requesting to add the plan to. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PlanRequesterInfo(string user, string date, string justification, string subscriptionId, string subscriptionName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            User = user;
            Date = date;
            Justification = justification;
            SubscriptionId = subscriptionId;
            SubscriptionName = subscriptionName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets user id. </summary>
        public string User { get; }
        /// <summary> Gets request date. </summary>
        public string Date { get; }
        /// <summary> Gets justification. </summary>
        public string Justification { get; }
        /// <summary> Gets the subscription id that the user is requesting to add the plan to. </summary>
        public string SubscriptionId { get; }
        /// <summary> Gets the subscription name that the user is requesting to add the plan to. </summary>
        public string SubscriptionName { get; }
    }
}
