// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Marketplace.Models
{
    /// <summary> Plan with requesters details. </summary>
    public partial class PlanRequesterDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PlanRequesterDetails"/>. </summary>
        internal PlanRequesterDetails()
        {
            Requesters = new ChangeTrackingList<PlanRequesterInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="PlanRequesterDetails"/>. </summary>
        /// <param name="planId"> Gets the plan id. </param>
        /// <param name="planDisplayName"> Gets the plan display name. </param>
        /// <param name="requesters"> Gets requesters details list. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PlanRequesterDetails(string planId, string planDisplayName, IReadOnlyList<PlanRequesterInfo> requesters, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PlanId = planId;
            PlanDisplayName = planDisplayName;
            Requesters = requesters;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the plan id. </summary>
        public string PlanId { get; }
        /// <summary> Gets the plan display name. </summary>
        public string PlanDisplayName { get; }
        /// <summary> Gets requesters details list. </summary>
        public IReadOnlyList<PlanRequesterInfo> Requesters { get; }
    }
}
