// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Marketplace.Models
{
    /// <summary> The subscription state. Possible values are Enabled, Warned, PastDue, Disabled, and Deleted. </summary>
    public readonly partial struct MarketplaceSubscriptionState : IEquatable<MarketplaceSubscriptionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MarketplaceSubscriptionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MarketplaceSubscriptionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string WarnedValue = "Warned";
        private const string PastDueValue = "PastDue";
        private const string DisabledValue = "Disabled";
        private const string DeletedValue = "Deleted";

        /// <summary> Enabled. </summary>
        public static MarketplaceSubscriptionState Enabled { get; } = new MarketplaceSubscriptionState(EnabledValue);
        /// <summary> Warned. </summary>
        public static MarketplaceSubscriptionState Warned { get; } = new MarketplaceSubscriptionState(WarnedValue);
        /// <summary> PastDue. </summary>
        public static MarketplaceSubscriptionState PastDue { get; } = new MarketplaceSubscriptionState(PastDueValue);
        /// <summary> Disabled. </summary>
        public static MarketplaceSubscriptionState Disabled { get; } = new MarketplaceSubscriptionState(DisabledValue);
        /// <summary> Deleted. </summary>
        public static MarketplaceSubscriptionState Deleted { get; } = new MarketplaceSubscriptionState(DeletedValue);
        /// <summary> Determines if two <see cref="MarketplaceSubscriptionState"/> values are the same. </summary>
        public static bool operator ==(MarketplaceSubscriptionState left, MarketplaceSubscriptionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MarketplaceSubscriptionState"/> values are not the same. </summary>
        public static bool operator !=(MarketplaceSubscriptionState left, MarketplaceSubscriptionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MarketplaceSubscriptionState"/>. </summary>
        public static implicit operator MarketplaceSubscriptionState(string value) => new MarketplaceSubscriptionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MarketplaceSubscriptionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MarketplaceSubscriptionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
