// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Marketplace.Models
{
    /// <summary> Rule type. </summary>
    public readonly partial struct MarketplaceRuleType : IEquatable<MarketplaceRuleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MarketplaceRuleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MarketplaceRuleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PrivateProductsValue = "PrivateProducts";
        private const string TermsAndConditionValue = "TermsAndCondition";

        /// <summary> PrivateProducts. </summary>
        public static MarketplaceRuleType PrivateProducts { get; } = new MarketplaceRuleType(PrivateProductsValue);
        /// <summary> TermsAndCondition. </summary>
        public static MarketplaceRuleType TermsAndCondition { get; } = new MarketplaceRuleType(TermsAndConditionValue);
        /// <summary> Determines if two <see cref="MarketplaceRuleType"/> values are the same. </summary>
        public static bool operator ==(MarketplaceRuleType left, MarketplaceRuleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MarketplaceRuleType"/> values are not the same. </summary>
        public static bool operator !=(MarketplaceRuleType left, MarketplaceRuleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MarketplaceRuleType"/>. </summary>
        public static implicit operator MarketplaceRuleType(string value) => new MarketplaceRuleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MarketplaceRuleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MarketplaceRuleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
