// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Marketplace.Models
{
    /// <summary> The subscriptions list to get the related collections. </summary>
    public partial class CollectionsToSubscriptionsMappingContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CollectionsToSubscriptionsMappingContent"/>. </summary>
        public CollectionsToSubscriptionsMappingContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CollectionsToSubscriptionsMappingContent"/>. </summary>
        /// <param name="properties"> Subscriptions ids list. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CollectionsToSubscriptionsMappingContent(CollectionsToSubscriptionsMappingProperties properties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Properties = properties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Subscriptions ids list. </summary>
        internal CollectionsToSubscriptionsMappingProperties Properties { get; set; }
        /// <summary> Subscriptions ids list. </summary>
        public IList<string> CollectionsToSubscriptionsMappingSubscriptionIds
        {
            get
            {
                if (Properties is null)
                    Properties = new CollectionsToSubscriptionsMappingProperties();
                return Properties.SubscriptionIds;
            }
        }
    }
}
