// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Marketplace.Mocking
{
    /// <summary> A class to add extension methods to TenantResource. </summary>
    public partial class MockableMarketplaceTenantResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableMarketplaceTenantResource"/> class for mocking. </summary>
        protected MockableMarketplaceTenantResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableMarketplaceTenantResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableMarketplaceTenantResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of PrivateStoreResources in the TenantResource. </summary>
        /// <returns> An object representing collection of PrivateStoreResources and their operations over a PrivateStoreResource. </returns>
        public virtual PrivateStoreCollection GetPrivateStores()
        {
            return GetCachedClient(client => new PrivateStoreCollection(client, Id));
        }

        /// <summary>
        /// Get information about the private store
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Marketplace/privateStores/{privateStoreId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateStore_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PrivateStoreResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        [ForwardsClientCalls]
        public virtual async Task<Response<PrivateStoreResource>> GetPrivateStoreAsync(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            return await GetPrivateStores().GetAsync(privateStoreId, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get information about the private store
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Marketplace/privateStores/{privateStoreId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PrivateStore_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="PrivateStoreResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="privateStoreId"> The store ID - must use the tenant ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        [ForwardsClientCalls]
        public virtual Response<PrivateStoreResource> GetPrivateStore(Guid privateStoreId, CancellationToken cancellationToken = default)
        {
            return GetPrivateStores().Get(privateStoreId, cancellationToken);
        }
    }
}
