// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Marketplace.Models;

namespace Azure.ResourceManager.Marketplace.Samples
{
    public partial class Sample_PrivateStoreResource
    {
        // GetPrivateStore
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetPrivateStore()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/GetPrivateStore.json
            // this example is just showing the usage of "PrivateStore_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // invoke the operation
            PrivateStoreResource result = await privateStore.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PrivateStoreData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PrivateStores_update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PrivateStoresUpdate()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/PrivateStores_update.json
            // this example is just showing the usage of "PrivateStore_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // invoke the operation
            PrivateStoreData data = new PrivateStoreData()
            {
                Availability = PrivateStoreAvailability.Disabled,
                ETag = new ETag("\"9301f4fd-0000-0100-0000-5e248b350345\""),
            };
            await privateStore.UpdateAsync(WaitUntil.Completed, data);

            Console.WriteLine($"Succeeded");
        }

        // DeletePrivateStores
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeletePrivateStores()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/DeletePrivateStore.json
            // this example is just showing the usage of "PrivateStore_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // invoke the operation
            await privateStore.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // AnyExistingOffersInTheCollections
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task AnyExistingOffersInTheCollections_AnyExistingOffersInTheCollections()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/AnyExistingOffersInTheCollections.json
            // this example is just showing the usage of "PrivateStore_AnyExistingOffersInTheCollections" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // invoke the operation
            AnyExistingOffersInTheCollectionsResult result = await privateStore.AnyExistingOffersInTheCollectionsAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // QueryOffers
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task QueryOffers_QueryOffers()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/QueryOffers.json
            // this example is just showing the usage of "PrivateStore_QueryOffers" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // invoke the operation and iterate over the result
            await foreach (PrivateStoreOfferResult item in privateStore.QueryOffersAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // QueryUserOffers
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task QueryUserOffers_QueryUserOffers()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/QueryUserOffers.json
            // this example is just showing the usage of "PrivateStore_QueryUserOffers" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // invoke the operation and iterate over the result
            QueryUserOffersContent content = new QueryUserOffersContent()
            {
                OfferIds =
{
"contoso.logger","contoso.monitor"
},
                SubscriptionIds =
{
"b340914e-353d-453a-85fb-8f9b65b51f91"
},
            };
            await foreach (PrivateStoreOfferResult item in privateStore.QueryUserOffersAsync(content: content))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // BillingAccounts
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task FetchBillingAccounts_BillingAccounts()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/BillingAccounts.json
            // this example is just showing the usage of "PrivateStore_BillingAccounts" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // invoke the operation
            PrivateStoreBillingAccountsResult result = await privateStore.FetchBillingAccountsAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // CollectionsToSubscriptionsMapping
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task FetchCollectionsToSubscriptionsMapping_CollectionsToSubscriptionsMapping()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/CollectionsToSubscriptionsMapping.json
            // this example is just showing the usage of "PrivateStore_CollectionsToSubscriptionsMapping" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // invoke the operation
            CollectionsToSubscriptionsMappingContent content = new CollectionsToSubscriptionsMappingContent()
            {
                CollectionsToSubscriptionsMappingSubscriptionIds =
{
"b340914e-353d-453a-85fb-8f9b65b51f91","f2baa04d-5bfc-461b-b6d8-61b403c9ec48"
},
            };
            CollectionsToSubscriptionsMappingResult result = await privateStore.FetchCollectionsToSubscriptionsMappingAsync(content: content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // QueryApprovedPlans
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task QueryApprovedPlans_QueryApprovedPlans()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/QueryApprovedPlans.json
            // this example is just showing the usage of "PrivateStore_QueryApprovedPlans" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // invoke the operation
            QueryApprovedPlansContent content = new QueryApprovedPlansContent()
            {
                OfferId = "marketplacetestthirdparty.md-test-third-party-2",
                PlanIds =
{
"testPlanA","testPlanB","testPlanC"
},
                SubscriptionIds =
{
"85e3e079-c718-4e4c-abbe-f72fceba8305","7752d461-4bf1-4185-8b56-8a3f11486ac6"
},
            };
            QueryApprovedPlansResult result = await privateStore.QueryApprovedPlansAsync(content: content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // BulkCollectionsAction
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task PerformActionOnBulkCollections_BulkCollectionsAction()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/BulkCollectionsAction.json
            // this example is just showing the usage of "PrivateStore_BulkCollectionsAction" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // invoke the operation
            BulkCollectionsActionContent content = new BulkCollectionsActionContent()
            {
                CollectionIds =
{
Guid.Parse("c752f021-1c37-4af5-b82f-74c51c27b44a"),Guid.Parse("f47ef1c7-e908-4f39-ae29-db181634ad8d")
},
                Action = "EnableCollections",
            };
            BulkCollectionsActionResult result = await privateStore.PerformActionOnBulkCollectionsAsync(content: content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // NotificationsState
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task QueryNotificationsState_NotificationsState()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/NotificationsState.json
            // this example is just showing the usage of "PrivateStore_QueryNotificationsState" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // invoke the operation
            PrivateStoreNotificationsState result = await privateStore.QueryNotificationsStateAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // AcknowledgeNotification
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task AcknowledgeOfferNotification_AcknowledgeNotification()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/AcknowledgeNotification.json
            // this example is just showing the usage of "PrivateStore_AcknowledgeOfferNotification" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // invoke the operation
            string offerId = "marketplacetestthirdparty.md-test-third-party-2";
            AcknowledgeOfferNotificationContent content = new AcknowledgeOfferNotificationContent()
            {
                IsAcknowledgeActionFlagEnabled = false,
                IsDismissActionFlagEnabled = false,
                IsRemoveOfferActionFlagEnabled = false,
                AddPlans =
{
},
                RemovePlans =
{
"testPlanA"
},
            };
            await privateStore.AcknowledgeOfferNotificationAsync(offerId, content: content);

            Console.WriteLine($"Succeeded");
        }

        // FetchAllSubscriptionsInTenant
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task FetchAllMarketplaceSubscriptions_FetchAllSubscriptionsInTenant()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/FetchAllSubscriptionsInTenant.json
            // this example is just showing the usage of "PrivateStore_FetchAllSubscriptionsInTenant" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // invoke the operation and iterate over the result
            await foreach (MarketplaceSubscription item in privateStore.FetchAllMarketplaceSubscriptionsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ListNewPlansNotifications
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetNewPlansNotifications_ListNewPlansNotifications()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/ListNewPlansNotifications.json
            // this example is just showing the usage of "PrivateStore_ListNewPlansNotifications" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // invoke the operation
            NewPlanNotificationListResult result = await privateStore.GetNewPlansNotificationsAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // ListStopSellOffersPlansNotifications
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetStopSellOffersPlansNotifications_ListStopSellOffersPlansNotifications()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/ListStopSellOffersPlansNotifications.json
            // this example is just showing the usage of "PrivateStore_ListStopSellOffersPlansNotifications" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // invoke the operation
            StopSellOffersPlansNotificationsList result = await privateStore.GetStopSellOffersPlansNotificationsAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // ListSubscriptionsContext
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSubscriptionsContext_ListSubscriptionsContext()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/ListSubscriptionsContext.json
            // this example is just showing the usage of "PrivateStore_ListSubscriptionsContext" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // invoke the operation
            SubscriptionsContextList result = await privateStore.GetSubscriptionsContextAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // QueryUserRules
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task QueryUserRules_QueryUserRules()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/QueryUserRules.json
            // this example is just showing the usage of "QueryUserRules" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // invoke the operation and iterate over the result
            QueryUserRulesContent content = new QueryUserRulesContent()
            {
                SubscriptionIds =
{
"b340914e-353d-453a-85fb-8f9b65b51f91"
},
            };
            await foreach (MarketplaceRule item in privateStore.QueryUserRulesAsync(content: content))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
