// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Marketplace.Models;

namespace Azure.ResourceManager.Marketplace.Samples
{
    public partial class Sample_MarketplaceAdminApprovalRequestCollection
    {
        // AdminRequestApprovalsList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_AdminRequestApprovalsList()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/AdminRequestApprovalsList.json
            // this example is just showing the usage of "PrivateStore_AdminRequestApprovalsList" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // get the collection of this MarketplaceAdminApprovalRequestResource
            MarketplaceAdminApprovalRequestCollection collection = privateStore.GetMarketplaceAdminApprovalRequests();

            // invoke the operation and iterate over the result
            await foreach (MarketplaceAdminApprovalRequestResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                MarketplaceAdminApprovalRequestData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // GetAdminRequestApproval
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAdminRequestApproval()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/GetAdminRequestApproval.json
            // this example is just showing the usage of "PrivateStore_GetAdminRequestApproval" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // get the collection of this MarketplaceAdminApprovalRequestResource
            MarketplaceAdminApprovalRequestCollection collection = privateStore.GetMarketplaceAdminApprovalRequests();

            // invoke the operation
            string adminRequestApprovalId = "marketplacetestthirdparty.md-test-third-party-2";
            string publisherId = "marketplacetestthirdparty";
            MarketplaceAdminApprovalRequestResource result = await collection.GetAsync(adminRequestApprovalId, publisherId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MarketplaceAdminApprovalRequestData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // GetAdminRequestApproval
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAdminRequestApproval()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/GetAdminRequestApproval.json
            // this example is just showing the usage of "PrivateStore_GetAdminRequestApproval" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // get the collection of this MarketplaceAdminApprovalRequestResource
            MarketplaceAdminApprovalRequestCollection collection = privateStore.GetMarketplaceAdminApprovalRequests();

            // invoke the operation
            string adminRequestApprovalId = "marketplacetestthirdparty.md-test-third-party-2";
            string publisherId = "marketplacetestthirdparty";
            bool result = await collection.ExistsAsync(adminRequestApprovalId, publisherId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // GetAdminRequestApproval
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAdminRequestApproval()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/GetAdminRequestApproval.json
            // this example is just showing the usage of "PrivateStore_GetAdminRequestApproval" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // get the collection of this MarketplaceAdminApprovalRequestResource
            MarketplaceAdminApprovalRequestCollection collection = privateStore.GetMarketplaceAdminApprovalRequests();

            // invoke the operation
            string adminRequestApprovalId = "marketplacetestthirdparty.md-test-third-party-2";
            string publisherId = "marketplacetestthirdparty";
            NullableResponse<MarketplaceAdminApprovalRequestResource> response = await collection.GetIfExistsAsync(adminRequestApprovalId, publisherId);
            MarketplaceAdminApprovalRequestResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                MarketplaceAdminApprovalRequestData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // UpdateAdminRequestApproval
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_UpdateAdminRequestApproval()
        {
            // Generated from example definition: specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2023-01-01/examples/UpdateAdminRequestApproval.json
            // this example is just showing the usage of "PrivateStore_UpdateAdminRequestApproval" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this PrivateStoreResource created on azure
            // for more information of creating PrivateStoreResource, please refer to the document of PrivateStoreResource
            Guid privateStoreId = Guid.Parse("a0e28e55-90c4-41d8-8e34-bb7ef7775406");
            ResourceIdentifier privateStoreResourceId = PrivateStoreResource.CreateResourceIdentifier(privateStoreId);
            PrivateStoreResource privateStore = client.GetPrivateStoreResource(privateStoreResourceId);

            // get the collection of this MarketplaceAdminApprovalRequestResource
            MarketplaceAdminApprovalRequestCollection collection = privateStore.GetMarketplaceAdminApprovalRequests();

            // invoke the operation
            string adminRequestApprovalId = "marketplacetestthirdparty.md-test-third-party-2";
            MarketplaceAdminApprovalRequestData data = new MarketplaceAdminApprovalRequestData()
            {
                PublisherId = "marketplacetestthirdparty",
                AdminAction = MarketplaceAdminAction.Approved,
                ApprovedPlans =
{
"testPlan"
},
                Comment = "I'm ok with that",
                CollectionIds =
{
Guid.Parse("f8ee227e-85d7-477d-abbf-854d6decaf70"),Guid.Parse("39246ad6-c521-4fed-8de7-77dede2e873f")
},
            };
            ArmOperation<MarketplaceAdminApprovalRequestResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, adminRequestApprovalId, data);
            MarketplaceAdminApprovalRequestResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MarketplaceAdminApprovalRequestData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
