// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Maps.Models
{
    /// <summary> The Map account key to use for signing. </summary>
    public readonly partial struct MapsSigningKey : IEquatable<MapsSigningKey>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MapsSigningKey"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MapsSigningKey(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PrimaryKeyValue = "primaryKey";
        private const string SecondaryKeyValue = "secondaryKey";

        /// <summary> primaryKey. </summary>
        public static MapsSigningKey PrimaryKey { get; } = new MapsSigningKey(PrimaryKeyValue);
        /// <summary> secondaryKey. </summary>
        public static MapsSigningKey SecondaryKey { get; } = new MapsSigningKey(SecondaryKeyValue);
        /// <summary> Determines if two <see cref="MapsSigningKey"/> values are the same. </summary>
        public static bool operator ==(MapsSigningKey left, MapsSigningKey right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MapsSigningKey"/> values are not the same. </summary>
        public static bool operator !=(MapsSigningKey left, MapsSigningKey right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MapsSigningKey"/>. </summary>
        public static implicit operator MapsSigningKey(string value) => new MapsSigningKey(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MapsSigningKey other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MapsSigningKey other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
