// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Maps.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableMapsArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableMapsArmClient"/> class for mocking. </summary>
        protected MockableMapsArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableMapsArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableMapsArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableMapsArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="MapsAccountResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MapsAccountResource.CreateResourceIdentifier" /> to create a <see cref="MapsAccountResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MapsAccountResource"/> object. </returns>
        public virtual MapsAccountResource GetMapsAccountResource(ResourceIdentifier id)
        {
            MapsAccountResource.ValidateResourceId(id);
            return new MapsAccountResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MapsCreatorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MapsCreatorResource.CreateResourceIdentifier" /> to create a <see cref="MapsCreatorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MapsCreatorResource"/> object. </returns>
        public virtual MapsCreatorResource GetMapsCreatorResource(ResourceIdentifier id)
        {
            MapsCreatorResource.ValidateResourceId(id);
            return new MapsCreatorResource(Client, id);
        }
    }
}
