// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using Azure.Core.GeoJson;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class WeatherWindow
    {
        internal static WeatherWindow DeserializeWeatherWindow(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            LatLongPair left = default;
            LatLongPair right = default;
            DateTimeOffset? beginDateTime = default;
            DateTimeOffset? endDateTime = default;
            string beginStatus = default;
            string endStatus = default;
            GeoObject geometry = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("left"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    left = LatLongPair.DeserializeLatLongPair(property.Value);
                    continue;
                }
                if (property.NameEquals("right"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    right = LatLongPair.DeserializeLatLongPair(property.Value);
                    continue;
                }
                if (property.NameEquals("beginDateTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    beginDateTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("endDateTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    endDateTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("beginStatus"u8))
                {
                    beginStatus = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("endStatus"u8))
                {
                    endStatus = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("geometry"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    geometry = JsonSerializer.Deserialize<GeoObject>(property.Value.GetRawText());
                    continue;
                }
            }
            return new WeatherWindow(
                left,
                right,
                beginDateTime,
                endDateTime,
                beginStatus,
                endStatus,
                geometry);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static WeatherWindow FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeWeatherWindow(document.RootElement);
        }
    }
}
