// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.Weather.Models
{
    public partial class WeatherValueYearMax
    {
        internal static WeatherValueYearMax DeserializeWeatherValueYearMax(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            WeatherValueYear maximum = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("maximum"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maximum = WeatherValueYear.DeserializeWeatherValueYear(property.Value);
                    continue;
                }
            }
            return new WeatherValueYearMax(maximum);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static WeatherValueYearMax FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeWeatherValueYearMax(document.RootElement);
        }
    }
}
