// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Maps.Weather.Models
{
    /// <summary> The WeatherValueYear. </summary>
    public partial class WeatherValueYear
    {
        /// <summary> Initializes a new instance of <see cref="WeatherValueYear"/>. </summary>
        internal WeatherValueYear()
        {
        }

        /// <summary> Initializes a new instance of <see cref="WeatherValueYear"/>. </summary>
        /// <param name="value"> Rounded value. </param>
        /// <param name="unit"> Type of unit for the returned value. </param>
        /// <param name="unitType"> Numeric ID value associated with the type of unit being displayed. Can be used for unit translation. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#daily-index-range-sets) for details. </param>
        /// <param name="year"> Year the value occurred. </param>
        internal WeatherValueYear(float? value, string unit, int? unitType, int? year)
        {
            Value = value;
            Unit = unit;
            UnitType = unitType;
            Year = year;
        }

        /// <summary> Rounded value. </summary>
        public float? Value { get; }
        /// <summary> Type of unit for the returned value. </summary>
        public string Unit { get; }
        /// <summary> Numeric ID value associated with the type of unit being displayed. Can be used for unit translation. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#daily-index-range-sets) for details. </summary>
        public int? UnitType { get; }
        /// <summary> Year the value occurred. </summary>
        public int? Year { get; }
    }
}
