// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    /// <summary> Description of the weather hazard affecting the trip. </summary>
    public partial class WeatherHazards
    {
        /// <summary> Initializes a new instance of <see cref="WeatherHazards"/>. </summary>
        internal WeatherHazards()
        {
            Details = new ChangeTrackingList<HazardDetail>();
        }

        /// <summary> Initializes a new instance of <see cref="WeatherHazards"/>. </summary>
        /// <param name="maxHazardIndex">
        /// A severity/hazard index.
        ///   * `0` - No hazard.
        ///   * `1` - Be informed, be aware.
        ///   * `2` - Pay attention, be prepared.
        ///   * `3` - Take action.
        ///   * `4` - Life threatening, emergency.
        /// </param>
        /// <param name="details"> Details of the weather hazards affecting the trip. </param>
        internal WeatherHazards(HazardIndex? maxHazardIndex, IReadOnlyList<HazardDetail> details)
        {
            MaxHazardIndex = maxHazardIndex;
            Details = details;
        }

        /// <summary>
        /// A severity/hazard index.
        ///   * `0` - No hazard.
        ///   * `1` - Be informed, be aware.
        ///   * `2` - Pay attention, be prepared.
        ///   * `3` - Take action.
        ///   * `4` - Life threatening, emergency.
        /// </summary>
        public HazardIndex? MaxHazardIndex { get; }
        /// <summary> Details of the weather hazards affecting the trip. </summary>
        public IReadOnlyList<HazardDetail> Details { get; }
    }
}
