// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class WeatherHazards
    {
        internal static WeatherHazards DeserializeWeatherHazards(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            HazardIndex? maxHazardIndex = default;
            IReadOnlyList<HazardDetail> hazardDetails = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("maxHazardIndex"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxHazardIndex = new HazardIndex(property.Value.GetInt32());
                    continue;
                }
                if (property.NameEquals("hazardDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<HazardDetail> array = new List<HazardDetail>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(HazardDetail.DeserializeHazardDetail(item));
                    }
                    hazardDetails = array;
                    continue;
                }
            }
            return new WeatherHazards(maxHazardIndex, hazardDetails ?? new ChangeTrackingList<HazardDetail>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static WeatherHazards FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeWeatherHazards(document.RootElement);
        }
    }
}
