// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.Weather.Models
{
    public partial class WeatherAlongRouteSummary
    {
        internal static WeatherAlongRouteSummary DeserializeWeatherAlongRouteSummary(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IconCode? iconCode = default;
            WeatherHazards hazards = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("iconCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    iconCode = new IconCode(property.Value.GetInt32());
                    continue;
                }
                if (property.NameEquals("hazards"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hazards = WeatherHazards.DeserializeWeatherHazards(property.Value);
                    continue;
                }
            }
            return new WeatherAlongRouteSummary(iconCode, hazards);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static WeatherAlongRouteSummary FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeWeatherAlongRouteSummary(document.RootElement);
        }
    }
}
