// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class WeatherAlongRouteResult
    {
        internal static WeatherAlongRouteResult DeserializeWeatherAlongRouteResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            WeatherAlongRouteSummary summary = default;
            IReadOnlyList<WaypointForecast> waypoints = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("summary"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    summary = WeatherAlongRouteSummary.DeserializeWeatherAlongRouteSummary(property.Value);
                    continue;
                }
                if (property.NameEquals("waypoints"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<WaypointForecast> array = new List<WaypointForecast>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(WaypointForecast.DeserializeWaypointForecast(item));
                    }
                    waypoints = array;
                    continue;
                }
            }
            return new WeatherAlongRouteResult(summary, waypoints ?? new ChangeTrackingList<WaypointForecast>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static WeatherAlongRouteResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeWeatherAlongRouteResult(document.RootElement);
        }
    }
}
