// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.Weather.Models
{
    public partial class WeatherAlongRoutePrecipitation
    {
        internal static WeatherAlongRoutePrecipitation DeserializeWeatherAlongRoutePrecipitation(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            double? dbz = default;
            string type = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("dbz"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dbz = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = property.Value.GetString();
                    continue;
                }
            }
            return new WeatherAlongRoutePrecipitation(dbz, type);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static WeatherAlongRoutePrecipitation FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeWeatherAlongRoutePrecipitation(document.RootElement);
        }
    }
}
