// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    /// <summary> The WaypointForecast. </summary>
    public partial class WaypointForecast
    {
        /// <summary> Initializes a new instance of <see cref="WaypointForecast"/>. </summary>
        internal WaypointForecast()
        {
            Notifications = new ChangeTrackingList<WeatherNotification>();
        }

        /// <summary> Initializes a new instance of <see cref="WaypointForecast"/>. </summary>
        /// <param name="iconCode"> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </param>
        /// <param name="shortDescription"> A displayable short phrase describing the forecasted conditions and precipitation intensity/type. </param>
        /// <param name="isDaytime"> Indicates the time of the day. True indicates 'day',', false indicates 'night. </param>
        /// <param name="cloudCover"> Percent representing cloud cover. </param>
        /// <param name="temperature"> Specific value of a given unit related to weather. </param>
        /// <param name="wind"> Wind details being returned including speed and direction. </param>
        /// <param name="windGust"> Wind details being returned including speed and direction. </param>
        /// <param name="precipitation"> Precipitation forecast of the weather along the route. </param>
        /// <param name="lightningCount"> Estimation of thunderstorm intensity on an open scale. A value of 0 means there is no thunderstorm; values of 1 and higher mean there is a thunderstorm in increasing intensity. </param>
        /// <param name="sunGlare"> A rating that indicates how blinding the sun is for the driver. </param>
        /// <param name="hazards"> Description of the weather hazard affecting the trip. </param>
        /// <param name="notifications"> List of weather hazard notifications. </param>
        internal WaypointForecast(IconCode? iconCode, string shortDescription, bool? isDaytime, int? cloudCover, WeatherValue temperature, WindDetails wind, WindDetails windGust, WeatherAlongRoutePrecipitation precipitation, int? lightningCount, SunGlare sunGlare, WeatherHazards hazards, IReadOnlyList<WeatherNotification> notifications)
        {
            IconCode = iconCode;
            ShortDescription = shortDescription;
            IsDaytime = isDaytime;
            CloudCover = cloudCover;
            Temperature = temperature;
            Wind = wind;
            WindGust = windGust;
            Precipitation = precipitation;
            LightningCount = lightningCount;
            SunGlare = sunGlare;
            Hazards = hazards;
            Notifications = notifications;
        }

        /// <summary> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </summary>
        public IconCode? IconCode { get; }
        /// <summary> A displayable short phrase describing the forecasted conditions and precipitation intensity/type. </summary>
        public string ShortDescription { get; }
        /// <summary> Indicates the time of the day. True indicates 'day',', false indicates 'night. </summary>
        public bool? IsDaytime { get; }
        /// <summary> Percent representing cloud cover. </summary>
        public int? CloudCover { get; }
        /// <summary> Specific value of a given unit related to weather. </summary>
        public WeatherValue Temperature { get; }
        /// <summary> Wind details being returned including speed and direction. </summary>
        public WindDetails Wind { get; }
        /// <summary> Wind details being returned including speed and direction. </summary>
        public WindDetails WindGust { get; }
        /// <summary> Precipitation forecast of the weather along the route. </summary>
        public WeatherAlongRoutePrecipitation Precipitation { get; }
        /// <summary> Estimation of thunderstorm intensity on an open scale. A value of 0 means there is no thunderstorm; values of 1 and higher mean there is a thunderstorm in increasing intensity. </summary>
        public int? LightningCount { get; }
        /// <summary> A rating that indicates how blinding the sun is for the driver. </summary>
        public SunGlare SunGlare { get; }
        /// <summary> Description of the weather hazard affecting the trip. </summary>
        public WeatherHazards Hazards { get; }
        /// <summary> List of weather hazard notifications. </summary>
        public IReadOnlyList<WeatherNotification> Notifications { get; }
    }
}
