// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class WaypointForecast
    {
        internal static WaypointForecast DeserializeWaypointForecast(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IconCode? iconCode = default;
            string shortPhrase = default;
            bool? isDayTime = default;
            int? cloudCover = default;
            WeatherValue temperature = default;
            WindDetails wind = default;
            WindDetails windGust = default;
            WeatherAlongRoutePrecipitation precipitation = default;
            int? lightningCount = default;
            SunGlare sunGlare = default;
            WeatherHazards hazards = default;
            IReadOnlyList<WeatherNotification> notifications = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("iconCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    iconCode = new IconCode(property.Value.GetInt32());
                    continue;
                }
                if (property.NameEquals("shortPhrase"u8))
                {
                    shortPhrase = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("isDayTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isDayTime = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("cloudCover"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cloudCover = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("temperature"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    temperature = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("wind"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    wind = WindDetails.DeserializeWindDetails(property.Value);
                    continue;
                }
                if (property.NameEquals("windGust"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    windGust = WindDetails.DeserializeWindDetails(property.Value);
                    continue;
                }
                if (property.NameEquals("precipitation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    precipitation = WeatherAlongRoutePrecipitation.DeserializeWeatherAlongRoutePrecipitation(property.Value);
                    continue;
                }
                if (property.NameEquals("lightningCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lightningCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("sunGlare"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sunGlare = SunGlare.DeserializeSunGlare(property.Value);
                    continue;
                }
                if (property.NameEquals("hazards"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hazards = WeatherHazards.DeserializeWeatherHazards(property.Value);
                    continue;
                }
                if (property.NameEquals("notifications"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<WeatherNotification> array = new List<WeatherNotification>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(WeatherNotification.DeserializeWeatherNotification(item));
                    }
                    notifications = array;
                    continue;
                }
            }
            return new WaypointForecast(
                iconCode,
                shortPhrase,
                isDayTime,
                cloudCover,
                temperature,
                wind,
                windGust,
                precipitation,
                lightningCount,
                sunGlare,
                hazards,
                notifications ?? new ChangeTrackingList<WeatherNotification>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static WaypointForecast FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeWaypointForecast(document.RootElement);
        }
    }
}
