// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;
using System.Globalization;

namespace Azure.Maps.Weather.Models
{
    /// <summary> Numeric ID value associated with the type of unit being displayed. Can be used for unit translation. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#unittype) for details. </summary>
    public readonly partial struct UnitType : IEquatable<UnitType>
    {
        private readonly int _value;

        /// <summary> Initializes a new instance of <see cref="UnitType"/>. </summary>
        public UnitType(int value)
        {
            _value = value;
        }

        private const int FeetValue = 0;
        private const int InchesValue = 1;
        private const int MilesValue = 2;
        private const int MillimeterValue = 3;
        private const int CentimeterValue = 4;
        private const int MeterValue = 5;
        private const int KilometerValue = 6;
        private const int KilometersPerHourValue = 7;
        private const int KnotsValue = 8;
        private const int MilesPerHourValue = 9;
        private const int MetersPerSecondValue = 10;
        private const int HectoPascalsValue = 11;
        private const int InchesOfMercuryValue = 12;
        private const int KiloPascalsValue = 13;
        private const int MillibarsValue = 14;
        private const int MillimetersOfMercuryValue = 15;
        private const int PoundsPerSquareInchValue = 16;
        private const int CelsiusValue = 17;
        private const int FahrenheitValue = 18;
        private const int KelvinValue = 19;
        private const int PercentValue = 20;
        private const int FloatValue = 21;
        private const int IntegerValue = 22;
        private const int MicrogramsPerCubicMeterOfAirValue = 31;

        /// <summary> feet. </summary>
        public static UnitType Feet { get; } = new UnitType(FeetValue);
        /// <summary> inches. </summary>
        public static UnitType Inches { get; } = new UnitType(InchesValue);
        /// <summary> miles. </summary>
        public static UnitType Miles { get; } = new UnitType(MilesValue);
        /// <summary> millimeter. </summary>
        public static UnitType Millimeter { get; } = new UnitType(MillimeterValue);
        /// <summary> centimeter. </summary>
        public static UnitType Centimeter { get; } = new UnitType(CentimeterValue);
        /// <summary> meter. </summary>
        public static UnitType Meter { get; } = new UnitType(MeterValue);
        /// <summary> kilometer. </summary>
        public static UnitType Kilometer { get; } = new UnitType(KilometerValue);
        /// <summary> kilometersPerHour. </summary>
        public static UnitType KilometersPerHour { get; } = new UnitType(KilometersPerHourValue);
        /// <summary> knots. </summary>
        public static UnitType Knots { get; } = new UnitType(KnotsValue);
        /// <summary> milesPerHour. </summary>
        public static UnitType MilesPerHour { get; } = new UnitType(MilesPerHourValue);
        /// <summary> metersPerSecond. </summary>
        public static UnitType MetersPerSecond { get; } = new UnitType(MetersPerSecondValue);
        /// <summary> hectoPascals. </summary>
        public static UnitType HectoPascals { get; } = new UnitType(HectoPascalsValue);
        /// <summary> inchesOfMercury. </summary>
        public static UnitType InchesOfMercury { get; } = new UnitType(InchesOfMercuryValue);
        /// <summary> kiloPascals. </summary>
        public static UnitType KiloPascals { get; } = new UnitType(KiloPascalsValue);
        /// <summary> millibars. </summary>
        public static UnitType Millibars { get; } = new UnitType(MillibarsValue);
        /// <summary> millimetersOfMercury. </summary>
        public static UnitType MillimetersOfMercury { get; } = new UnitType(MillimetersOfMercuryValue);
        /// <summary> poundsPerSquareInch. </summary>
        public static UnitType PoundsPerSquareInch { get; } = new UnitType(PoundsPerSquareInchValue);
        /// <summary> celsius. </summary>
        public static UnitType Celsius { get; } = new UnitType(CelsiusValue);
        /// <summary> fahrenheit. </summary>
        public static UnitType Fahrenheit { get; } = new UnitType(FahrenheitValue);
        /// <summary> kelvin. </summary>
        public static UnitType Kelvin { get; } = new UnitType(KelvinValue);
        /// <summary> percent. </summary>
        public static UnitType Percent { get; } = new UnitType(PercentValue);
        /// <summary> float. </summary>
        public static UnitType Float { get; } = new UnitType(FloatValue);
        /// <summary> integer. </summary>
        public static UnitType Integer { get; } = new UnitType(IntegerValue);
        /// <summary> MicrogramsPerCubicMeterOfAir. </summary>
        public static UnitType MicrogramsPerCubicMeterOfAir { get; } = new UnitType(MicrogramsPerCubicMeterOfAirValue);

        internal int ToSerialInt32() => _value;

        /// <summary> Determines if two <see cref="UnitType"/> values are the same. </summary>
        public static bool operator ==(UnitType left, UnitType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UnitType"/> values are not the same. </summary>
        public static bool operator !=(UnitType left, UnitType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="int"/> to a <see cref="UnitType"/>. </summary>
        public static implicit operator UnitType(int value) => new UnitType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UnitType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UnitType other) => Equals(_value, other._value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value.GetHashCode();
        /// <inheritdoc />
        public override string ToString() => _value.ToString(CultureInfo.InvariantCulture);
    }
}
