// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.Weather.Models
{
    public partial class TemperatureSummary
    {
        internal static TemperatureSummary DeserializeTemperatureSummary(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            PastHoursTemperature pastSixHours = default;
            PastHoursTemperature pastTwelveHours = default;
            PastHoursTemperature pastTwentyFourHours = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("pastSixHours"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pastSixHours = PastHoursTemperature.DeserializePastHoursTemperature(property.Value);
                    continue;
                }
                if (property.NameEquals("pastTwelveHours"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pastTwelveHours = PastHoursTemperature.DeserializePastHoursTemperature(property.Value);
                    continue;
                }
                if (property.NameEquals("pastTwentyFourHours"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pastTwentyFourHours = PastHoursTemperature.DeserializePastHoursTemperature(property.Value);
                    continue;
                }
            }
            return new TemperatureSummary(pastSixHours, pastTwelveHours, pastTwentyFourHours);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static TemperatureSummary FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeTemperatureSummary(document.RootElement);
        }
    }
}
