// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.Weather.Models
{
    public partial class SunGlare
    {
        internal static SunGlare DeserializeSunGlare(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? calculatedVehicleHeading = default;
            int? glareIndex = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("calculatedVehicleHeading"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    calculatedVehicleHeading = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("glareIndex"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    glareIndex = property.Value.GetInt32();
                    continue;
                }
            }
            return new SunGlare(calculatedVehicleHeading, glareIndex);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SunGlare FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSunGlare(document.RootElement);
        }
    }
}
