// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Core.GeoJson;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class StormWindRadiiSummary
    {
        internal static StormWindRadiiSummary DeserializeStormWindRadiiSummary(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string dateTime = default;
            WeatherValue windSpeed = default;
            IReadOnlyList<RadiusSector> radiusSectorData = default;
            GeoObject radiiGeometry = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("dateTime"u8))
                {
                    dateTime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("windSpeed"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    windSpeed = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("radiusSectorData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<RadiusSector> array = new List<RadiusSector>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(RadiusSector.DeserializeRadiusSector(item));
                    }
                    radiusSectorData = array;
                    continue;
                }
                if (property.NameEquals("radiiGeometry"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    radiiGeometry = JsonSerializer.Deserialize<GeoObject>(property.Value.GetRawText());
                    continue;
                }
            }
            return new StormWindRadiiSummary(dateTime, windSpeed, radiusSectorData ?? new ChangeTrackingList<RadiusSector>(), radiiGeometry);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static StormWindRadiiSummary FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeStormWindRadiiSummary(document.RootElement);
        }
    }
}
