// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    /// <summary> Search government-issued storms. </summary>
    public partial class StormSearchResult
    {
        /// <summary> Initializes a new instance of <see cref="StormSearchResult"/>. </summary>
        internal StormSearchResult()
        {
            Storms = new ChangeTrackingList<StormSearchResultItem>();
        }

        /// <summary> Initializes a new instance of <see cref="StormSearchResult"/>. </summary>
        /// <param name="storms"> Search government-issued storms. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        internal StormSearchResult(IReadOnlyList<StormSearchResultItem> storms, string nextLink)
        {
            Storms = storms;
            NextLink = nextLink;
        }

        /// <summary> Search government-issued storms. </summary>
        public IReadOnlyList<StormSearchResultItem> Storms { get; }
        /// <summary> The is the link to the next page of the features returned. If it's the last page, no this field. </summary>
        public string NextLink { get; }
    }
}
