// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    /// <summary> Locations for an individual government-issued storm. </summary>
    public partial class StormLocationsResult
    {
        /// <summary> Initializes a new instance of <see cref="StormLocationsResult"/>. </summary>
        internal StormLocationsResult()
        {
            StormLocations = new ChangeTrackingList<StormLocation>();
        }

        /// <summary> Initializes a new instance of <see cref="StormLocationsResult"/>. </summary>
        /// <param name="stormLocations"> Locations for an individual government-issued storm. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        internal StormLocationsResult(IReadOnlyList<StormLocation> stormLocations, string nextLink)
        {
            StormLocations = stormLocations;
            NextLink = nextLink;
        }

        /// <summary> Locations for an individual government-issued storm. </summary>
        public IReadOnlyList<StormLocation> StormLocations { get; }
        /// <summary> The is the link to the next page of the features returned. If it's the last page, no this field. </summary>
        public string NextLink { get; }
    }
}
