// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class StormLocation
    {
        internal static StormLocation DeserializeStormLocation(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string dateTime = default;
            LatLongPair location = default;
            WeatherValue maxWindGust = default;
            WeatherValue sustainedWind = default;
            WeatherValue minimumPressure = default;
            WindDetails movement = default;
            string status = default;
            bool? isSubtropical = default;
            bool? hasTropicalPotential = default;
            bool? isPostTropical = default;
            IReadOnlyList<StormWindRadiiSummary> windRadiiSummary = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("dateTime"u8))
                {
                    dateTime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    location = LatLongPair.DeserializeLatLongPair(property.Value);
                    continue;
                }
                if (property.NameEquals("maxWindGust"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxWindGust = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("sustainedWind"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sustainedWind = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("minimumPressure"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minimumPressure = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("movement"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    movement = WindDetails.DeserializeWindDetails(property.Value);
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    status = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("isSubtropical"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isSubtropical = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("hasTropicalPotential"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hasTropicalPotential = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isPostTropical"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isPostTropical = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("windRadiiSummary"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<StormWindRadiiSummary> array = new List<StormWindRadiiSummary>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(StormWindRadiiSummary.DeserializeStormWindRadiiSummary(item));
                    }
                    windRadiiSummary = array;
                    continue;
                }
            }
            return new StormLocation(
                dateTime,
                location,
                maxWindGust,
                sustainedWind,
                minimumPressure,
                movement,
                status,
                isSubtropical,
                hasTropicalPotential,
                isPostTropical,
                windRadiiSummary ?? new ChangeTrackingList<StormWindRadiiSummary>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static StormLocation FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeStormLocation(document.RootElement);
        }
    }
}
