// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    /// <summary> The list of Government-issued forecasts. </summary>
    public partial class StormForecastResult
    {
        /// <summary> Initializes a new instance of <see cref="StormForecastResult"/>. </summary>
        internal StormForecastResult()
        {
            StormForecasts = new ChangeTrackingList<StormForecast>();
        }

        /// <summary> Initializes a new instance of <see cref="StormForecastResult"/>. </summary>
        /// <param name="stormForecasts"> The list of Government-issued forecasts. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        internal StormForecastResult(IReadOnlyList<StormForecast> stormForecasts, string nextLink)
        {
            StormForecasts = stormForecasts;
            NextLink = nextLink;
        }

        /// <summary> The list of Government-issued forecasts. </summary>
        public IReadOnlyList<StormForecast> StormForecasts { get; }
        /// <summary> The is the link to the next page of the features returned. If it's the last page, no this field. </summary>
        public string NextLink { get; }
    }
}
