// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    /// <summary> Government-issued storm forecast. </summary>
    public partial class StormForecast
    {
        /// <summary> Initializes a new instance of <see cref="StormForecast"/>. </summary>
        internal StormForecast()
        {
            WindRadiiSummary = new ChangeTrackingList<StormWindRadiiSummary>();
        }

        /// <summary> Initializes a new instance of <see cref="StormForecast"/>. </summary>
        /// <param name="timestamp"> Datetime the forecast is valid, displayed in ISO8601 format. </param>
        /// <param name="initializedTimestamp"> Datetime the forecast was created, displayed in ISO8601 format. </param>
        /// <param name="coordinates"> Coordinates of the storm. </param>
        /// <param name="maxWindGust"> Maximum wind gust speed associated with the storm. May be NULL. </param>
        /// <param name="sustainedWind"> Maximum sustained wind speed associated with the storm. May be NULL. </param>
        /// <param name="status"> Possible status values include:&lt;ul&gt;&lt;li&gt;Cyclonic storm&lt;/li&gt;&lt;li&gt;Deep depression&lt;/li&gt;&lt;li&gt;Depression&lt;/li&gt;&lt;li&gt;Extremely severe cyclonic storm&lt;/li&gt;&lt;li&gt;Hurricane category (1-5)&lt;/li&gt;&lt;li&gt;Intense tropical cyclone&lt;/li&gt;&lt;li&gt;Moderate tropical storm&lt;/li&gt;&lt;li&gt;Post-tropical cyclone&lt;/li&gt;&lt;li&gt;Potential tropical cyclone&lt;/li&gt;&lt;li&gt;Severe cyclonic storm&lt;/li&gt;&lt;li&gt;Severe tropical storm&lt;/li&gt;&lt;li&gt;Subtropical&lt;/li&gt;&lt;li&gt;Super cyclonic storm&lt;/li&gt;&lt;li&gt;Tropical cyclone&lt;/li&gt;&lt;li&gt;Tropical cyclone category (1-5)&lt;/li&gt;&lt;li&gt;Tropical depression&lt;/li&gt;&lt;li&gt;Tropical disturbance&lt;/li&gt;&lt;li&gt;Tropical storm&lt;/li&gt;&lt;li&gt;Typhoon&lt;/li&gt;&lt;li&gt;Very intense tropical cyclone&lt;/li&gt;&lt;li&gt;Very severe cyclonic storm&lt;/li&gt;&lt;li&gt;Very strong typhoon&lt;/li&gt;&lt;li&gt;Violent typhoon&lt;/li&gt;&lt;/ul&gt;. </param>
        /// <param name="weatherWindow"> Contains information about the forecast window for the storm during the specified time period (not the entire cone). If windowGeometry=true in the request, this object will include geoJSON details for window geometry. </param>
        /// <param name="windRadiiSummary"> Displayed when details=true or radiiGeometry=true in the request. </param>
        internal StormForecast(string timestamp, string initializedTimestamp, LatLongPair coordinates, WeatherValue maxWindGust, WeatherValue sustainedWind, string status, WeatherWindow weatherWindow, IReadOnlyList<StormWindRadiiSummary> windRadiiSummary)
        {
            Timestamp = timestamp;
            InitializedTimestamp = initializedTimestamp;
            Coordinates = coordinates;
            MaxWindGust = maxWindGust;
            SustainedWind = sustainedWind;
            Status = status;
            WeatherWindow = weatherWindow;
            WindRadiiSummary = windRadiiSummary;
        }

        /// <summary> Datetime the forecast is valid, displayed in ISO8601 format. </summary>
        public string Timestamp { get; }
        /// <summary> Datetime the forecast was created, displayed in ISO8601 format. </summary>
        public string InitializedTimestamp { get; }
        /// <summary> Coordinates of the storm. </summary>
        public LatLongPair Coordinates { get; }
        /// <summary> Maximum wind gust speed associated with the storm. May be NULL. </summary>
        public WeatherValue MaxWindGust { get; }
        /// <summary> Maximum sustained wind speed associated with the storm. May be NULL. </summary>
        public WeatherValue SustainedWind { get; }
        /// <summary> Possible status values include:&lt;ul&gt;&lt;li&gt;Cyclonic storm&lt;/li&gt;&lt;li&gt;Deep depression&lt;/li&gt;&lt;li&gt;Depression&lt;/li&gt;&lt;li&gt;Extremely severe cyclonic storm&lt;/li&gt;&lt;li&gt;Hurricane category (1-5)&lt;/li&gt;&lt;li&gt;Intense tropical cyclone&lt;/li&gt;&lt;li&gt;Moderate tropical storm&lt;/li&gt;&lt;li&gt;Post-tropical cyclone&lt;/li&gt;&lt;li&gt;Potential tropical cyclone&lt;/li&gt;&lt;li&gt;Severe cyclonic storm&lt;/li&gt;&lt;li&gt;Severe tropical storm&lt;/li&gt;&lt;li&gt;Subtropical&lt;/li&gt;&lt;li&gt;Super cyclonic storm&lt;/li&gt;&lt;li&gt;Tropical cyclone&lt;/li&gt;&lt;li&gt;Tropical cyclone category (1-5)&lt;/li&gt;&lt;li&gt;Tropical depression&lt;/li&gt;&lt;li&gt;Tropical disturbance&lt;/li&gt;&lt;li&gt;Tropical storm&lt;/li&gt;&lt;li&gt;Typhoon&lt;/li&gt;&lt;li&gt;Very intense tropical cyclone&lt;/li&gt;&lt;li&gt;Very severe cyclonic storm&lt;/li&gt;&lt;li&gt;Very strong typhoon&lt;/li&gt;&lt;li&gt;Violent typhoon&lt;/li&gt;&lt;/ul&gt;. </summary>
        public string Status { get; }
        /// <summary> Contains information about the forecast window for the storm during the specified time period (not the entire cone). If windowGeometry=true in the request, this object will include geoJSON details for window geometry. </summary>
        public WeatherWindow WeatherWindow { get; }
        /// <summary> Displayed when details=true or radiiGeometry=true in the request. </summary>
        public IReadOnlyList<StormWindRadiiSummary> WindRadiiSummary { get; }
    }
}
