// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class StormForecast
    {
        internal static StormForecast DeserializeStormForecast(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string dateTime = default;
            string initializedDateTime = default;
            LatLongPair location = default;
            WeatherValue maxWindGust = default;
            WeatherValue sustainedWind = default;
            string status = default;
            WeatherWindow window = default;
            IReadOnlyList<StormWindRadiiSummary> windRadiiSummary = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("dateTime"u8))
                {
                    dateTime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("initializedDateTime"u8))
                {
                    initializedDateTime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    location = LatLongPair.DeserializeLatLongPair(property.Value);
                    continue;
                }
                if (property.NameEquals("maxWindGust"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxWindGust = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("sustainedWind"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sustainedWind = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    status = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("window"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    window = WeatherWindow.DeserializeWeatherWindow(property.Value);
                    continue;
                }
                if (property.NameEquals("windRadiiSummary"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<StormWindRadiiSummary> array = new List<StormWindRadiiSummary>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(StormWindRadiiSummary.DeserializeStormWindRadiiSummary(item));
                    }
                    windRadiiSummary = array;
                    continue;
                }
            }
            return new StormForecast(
                dateTime,
                initializedDateTime,
                location,
                maxWindGust,
                sustainedWind,
                status,
                window,
                windRadiiSummary ?? new ChangeTrackingList<StormWindRadiiSummary>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static StormForecast FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeStormForecast(document.RootElement);
        }
    }
}
