// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    /// <summary> This object is returned from a successful Get Severe Weather Alerts call. </summary>
    public partial class SevereWeatherAlertsResult
    {
        /// <summary> Initializes a new instance of <see cref="SevereWeatherAlertsResult"/>. </summary>
        internal SevereWeatherAlertsResult()
        {
            Results = new ChangeTrackingList<SevereWeatherAlert>();
        }

        /// <summary> Initializes a new instance of <see cref="SevereWeatherAlertsResult"/>. </summary>
        /// <param name="results"> A list of all severe weather alerts for the queried location. </param>
        internal SevereWeatherAlertsResult(IReadOnlyList<SevereWeatherAlert> results)
        {
            Results = results;
        }

        /// <summary> A list of all severe weather alerts for the queried location. </summary>
        public IReadOnlyList<SevereWeatherAlert> Results { get; }
    }
}
