// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class SevereWeatherAlertsResult
    {
        internal static SevereWeatherAlertsResult DeserializeSevereWeatherAlertsResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<SevereWeatherAlert> results = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("results"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SevereWeatherAlert> array = new List<SevereWeatherAlert>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SevereWeatherAlert.DeserializeSevereWeatherAlert(item));
                    }
                    results = array;
                    continue;
                }
            }
            return new SevereWeatherAlertsResult(results ?? new ChangeTrackingList<SevereWeatherAlert>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SevereWeatherAlertsResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSevereWeatherAlertsResult(document.RootElement);
        }
    }
}
