// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    /// <summary> Information about a severe weather alert. </summary>
    public partial class SevereWeatherAlert
    {
        /// <summary> Initializes a new instance of <see cref="SevereWeatherAlert"/>. </summary>
        internal SevereWeatherAlert()
        {
            AlertDetails = new ChangeTrackingList<AlertDetails>();
        }

        /// <summary> Initializes a new instance of <see cref="SevereWeatherAlert"/>. </summary>
        /// <param name="countryCode"> 2-character ISO 3166-1 Alpha-2 country code, for example, "US". </param>
        /// <param name="alertId"> A unique numerical identifier for a weather alert. </param>
        /// <param name="description"> Description of the alert. </param>
        /// <param name="category"> Category of the alert. </param>
        /// <param name="priority"> Number signifying the importance or ranking order of the given alert within the country/region it has originated. A lower number signifies a higher priority. For example, 1 is the highest priority. The number varies by country/region and can change over time as each country/region evolves their alert systems. </param>
        /// <param name="classification"> Classification of the alert. This field is not available for all countries and therefore not always returned. </param>
        /// <param name="level"> Severity level of the alert. This field is not available for all countries and therefore not always returned. </param>
        /// <param name="source"> The provider of the alert information. By default the source is returned in English (en-US). The alerts are from official Government Meteorological Agencies and leading global weather alert providers. </param>
        /// <param name="sourceId"> A numerical identifier associated with the source provider name of the alert data. </param>
        /// <param name="disclaimer"> A disclaimer regarding the source of the alert information. This field is not always available. For example, disclaimer may include details about the delays or potential issues related to the alarm. </param>
        /// <param name="alertDetails"> Information about the alert specific to the affected area(s). </param>
        internal SevereWeatherAlert(string countryCode, int? alertId, SevereWeatherAlertDescription description, string category, int? priority, string classification, string level, string source, int? sourceId, string disclaimer, IReadOnlyList<AlertDetails> alertDetails)
        {
            CountryCode = countryCode;
            AlertId = alertId;
            Description = description;
            Category = category;
            Priority = priority;
            Classification = classification;
            Level = level;
            Source = source;
            SourceId = sourceId;
            Disclaimer = disclaimer;
            AlertDetails = alertDetails;
        }

        /// <summary> 2-character ISO 3166-1 Alpha-2 country code, for example, "US". </summary>
        public string CountryCode { get; }
        /// <summary> A unique numerical identifier for a weather alert. </summary>
        public int? AlertId { get; }
        /// <summary> Description of the alert. </summary>
        public SevereWeatherAlertDescription Description { get; }
        /// <summary> Category of the alert. </summary>
        public string Category { get; }
        /// <summary> Number signifying the importance or ranking order of the given alert within the country/region it has originated. A lower number signifies a higher priority. For example, 1 is the highest priority. The number varies by country/region and can change over time as each country/region evolves their alert systems. </summary>
        public int? Priority { get; }
        /// <summary> Classification of the alert. This field is not available for all countries and therefore not always returned. </summary>
        public string Classification { get; }
        /// <summary> Severity level of the alert. This field is not available for all countries and therefore not always returned. </summary>
        public string Level { get; }
        /// <summary> The provider of the alert information. By default the source is returned in English (en-US). The alerts are from official Government Meteorological Agencies and leading global weather alert providers. </summary>
        public string Source { get; }
        /// <summary> A numerical identifier associated with the source provider name of the alert data. </summary>
        public int? SourceId { get; }
        /// <summary> A disclaimer regarding the source of the alert information. This field is not always available. For example, disclaimer may include details about the delays or potential issues related to the alarm. </summary>
        public string Disclaimer { get; }
        /// <summary> Information about the alert specific to the affected area(s). </summary>
        public IReadOnlyList<AlertDetails> AlertDetails { get; }
    }
}
