// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Maps.Weather.Models
{
    /// <summary> Bearing 0–90 = NE quadrant; 90–180 = SE quadrant; 180–270 = SW quadrant; 270–360 = NW quadrant. </summary>
    public partial class RadiusSector
    {
        /// <summary> Initializes a new instance of <see cref="RadiusSector"/>. </summary>
        internal RadiusSector()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RadiusSector"/>. </summary>
        /// <param name="beginBearing"> Bearing, in degrees, of the beginning of the quadrant. </param>
        /// <param name="endBearing"> Bearing, in degrees, of the end of the quadrant. </param>
        /// <param name="radius"> The radius of the quadrant, in nautical miles. </param>
        internal RadiusSector(double? beginBearing, double? endBearing, double? radius)
        {
            BeginBearing = beginBearing;
            EndBearing = endBearing;
            Radius = radius;
        }

        /// <summary> Bearing, in degrees, of the beginning of the quadrant. </summary>
        public double? BeginBearing { get; }
        /// <summary> Bearing, in degrees, of the end of the quadrant. </summary>
        public double? EndBearing { get; }
        /// <summary> The radius of the quadrant, in nautical miles. </summary>
        public double? Radius { get; }
    }
}
