// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.Weather.Models
{
    public partial class RadiusSector
    {
        internal static RadiusSector DeserializeRadiusSector(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            double? beginBearing = default;
            double? endBearing = default;
            double? range = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("beginBearing"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    beginBearing = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("endBearing"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    endBearing = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("range"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    range = property.Value.GetDouble();
                    continue;
                }
            }
            return new RadiusSector(beginBearing, endBearing, range);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RadiusSector FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRadiusSector(document.RootElement);
        }
    }
}
