// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Maps.Weather.Models
{
    /// <summary> The QuarterDayForecast. </summary>
    public partial class QuarterDayForecast
    {
        /// <summary> Initializes a new instance of <see cref="QuarterDayForecast"/>. </summary>
        internal QuarterDayForecast()
        {
        }

        /// <summary> Initializes a new instance of <see cref="QuarterDayForecast"/>. </summary>
        /// <param name="dateTime"> Date of the forecast as example, 2019-10-27T00:00:00. </param>
        /// <param name="effectiveDate"> Date and time of the beginning of the forecast quarter displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="quarter"> Quarter of the day. </param>
        /// <param name="iconCode"> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </param>
        /// <param name="iconPhrase"> Phrase description of the icon. Displayed in specified language. For example, 'Sunny'. </param>
        /// <param name="phrase"> Short summary phrase summary for quarter. </param>
        /// <param name="temperature"> Temperature values for the quarter. </param>
        /// <param name="realFeelTemperature"> RealFeel™ Temperature values for the quarter. </param>
        /// <param name="dewPoint"> The dewpoint temperature in specified unit. The dewpoint temperature is the temperature that the air must be cooled to in order to reach saturation. </param>
        /// <param name="relativeHumidity"> Relative humidity is the amount of water vapor present in air expressed as a percentage of the amount needed for saturation at the same temperature. </param>
        /// <param name="wind"> Wind details being returned including speed and direction. </param>
        /// <param name="windGust"> Wind gust. Wind gust is a sudden, brief increase in speed of the wind. </param>
        /// <param name="visibility"> Visibility in specified unit. A measure of the distance at which an object or light can be clearly discerned. </param>
        /// <param name="cloudCover"> Percent representing cloud cover. </param>
        /// <param name="hasPrecipitation"> Indicates the presence or absence of precipitation. True indicates the presence of precipitation, false indicates the absence of precipitation. </param>
        /// <param name="precipitationType"> Specifies the type of precipitation ("Rain" "Snow" "Ice" or "Mix"). If dbz is zero, precipitationType is not present in the response. </param>
        /// <param name="precipitationIntensity"> Description of the intensity. </param>
        /// <param name="precipitationProbability"> Percent representing the probability of precipitation. For example, '20'. </param>
        /// <param name="thunderstormProbability"> Percent representing the probability of a thunderstorm. For example, '10'. </param>
        /// <param name="totalLiquid"> Total liquid equivalent of precipitation during the forecast period. </param>
        /// <param name="rain"> Rain. </param>
        /// <param name="snow"> Snow. </param>
        /// <param name="ice"> Ice. </param>
        internal QuarterDayForecast(DateTimeOffset? dateTime, DateTimeOffset? effectiveDate, DayQuarter? quarter, IconCode? iconCode, string iconPhrase, string phrase, WeatherValueRange temperature, WeatherValueRange realFeelTemperature, WeatherValue dewPoint, int? relativeHumidity, WindDetails wind, WindDetails windGust, WeatherValue visibility, int? cloudCover, bool? hasPrecipitation, PrecipitationType? precipitationType, string precipitationIntensity, int? precipitationProbability, int? thunderstormProbability, WeatherValue totalLiquid, WeatherValue rain, WeatherValue snow, WeatherValue ice)
        {
            DateTime = dateTime;
            EffectiveDate = effectiveDate;
            Quarter = quarter;
            IconCode = iconCode;
            IconPhrase = iconPhrase;
            Phrase = phrase;
            Temperature = temperature;
            RealFeelTemperature = realFeelTemperature;
            DewPoint = dewPoint;
            RelativeHumidity = relativeHumidity;
            Wind = wind;
            WindGust = windGust;
            Visibility = visibility;
            CloudCover = cloudCover;
            HasPrecipitation = hasPrecipitation;
            PrecipitationType = precipitationType;
            PrecipitationIntensity = precipitationIntensity;
            PrecipitationProbability = precipitationProbability;
            ThunderstormProbability = thunderstormProbability;
            TotalLiquid = totalLiquid;
            Rain = rain;
            Snow = snow;
            Ice = ice;
        }

        /// <summary> Date of the forecast as example, 2019-10-27T00:00:00. </summary>
        public DateTimeOffset? DateTime { get; }
        /// <summary> Date and time of the beginning of the forecast quarter displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </summary>
        public DateTimeOffset? EffectiveDate { get; }
        /// <summary> Quarter of the day. </summary>
        public DayQuarter? Quarter { get; }
        /// <summary> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </summary>
        public IconCode? IconCode { get; }
        /// <summary> Phrase description of the icon. Displayed in specified language. For example, 'Sunny'. </summary>
        public string IconPhrase { get; }
        /// <summary> Short summary phrase summary for quarter. </summary>
        public string Phrase { get; }
        /// <summary> Temperature values for the quarter. </summary>
        public WeatherValueRange Temperature { get; }
        /// <summary> RealFeel™ Temperature values for the quarter. </summary>
        public WeatherValueRange RealFeelTemperature { get; }
        /// <summary> The dewpoint temperature in specified unit. The dewpoint temperature is the temperature that the air must be cooled to in order to reach saturation. </summary>
        public WeatherValue DewPoint { get; }
        /// <summary> Relative humidity is the amount of water vapor present in air expressed as a percentage of the amount needed for saturation at the same temperature. </summary>
        public int? RelativeHumidity { get; }
        /// <summary> Wind details being returned including speed and direction. </summary>
        public WindDetails Wind { get; }
        /// <summary> Wind gust. Wind gust is a sudden, brief increase in speed of the wind. </summary>
        public WindDetails WindGust { get; }
        /// <summary> Visibility in specified unit. A measure of the distance at which an object or light can be clearly discerned. </summary>
        public WeatherValue Visibility { get; }
        /// <summary> Percent representing cloud cover. </summary>
        public int? CloudCover { get; }
        /// <summary> Indicates the presence or absence of precipitation. True indicates the presence of precipitation, false indicates the absence of precipitation. </summary>
        public bool? HasPrecipitation { get; }
        /// <summary> Specifies the type of precipitation ("Rain" "Snow" "Ice" or "Mix"). If dbz is zero, precipitationType is not present in the response. </summary>
        public PrecipitationType? PrecipitationType { get; }
        /// <summary> Description of the intensity. </summary>
        public string PrecipitationIntensity { get; }
        /// <summary> Percent representing the probability of precipitation. For example, '20'. </summary>
        public int? PrecipitationProbability { get; }
        /// <summary> Percent representing the probability of a thunderstorm. For example, '10'. </summary>
        public int? ThunderstormProbability { get; }
        /// <summary> Total liquid equivalent of precipitation during the forecast period. </summary>
        public WeatherValue TotalLiquid { get; }
        /// <summary> Rain. </summary>
        public WeatherValue Rain { get; }
        /// <summary> Snow. </summary>
        public WeatherValue Snow { get; }
        /// <summary> Ice. </summary>
        public WeatherValue Ice { get; }
    }
}
