// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class QuarterDayForecast
    {
        internal static QuarterDayForecast DeserializeQuarterDayForecast(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? date = default;
            DateTimeOffset? effectiveDate = default;
            DayQuarter? quarter = default;
            IconCode? iconCode = default;
            string iconPhrase = default;
            string phrase = default;
            WeatherValueRange temperature = default;
            WeatherValueRange realFeelTemperature = default;
            WeatherValue dewPoint = default;
            int? relativeHumidity = default;
            WindDetails wind = default;
            WindDetails windGust = default;
            WeatherValue visibility = default;
            int? cloudCover = default;
            bool? hasPrecipitation = default;
            PrecipitationType? precipitationType = default;
            string precipitationIntensity = default;
            int? precipitationProbability = default;
            int? thunderstormProbability = default;
            WeatherValue totalLiquid = default;
            WeatherValue rain = default;
            WeatherValue snow = default;
            WeatherValue ice = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("date"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    date = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("effectiveDate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    effectiveDate = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("quarter"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    quarter = new DayQuarter(property.Value.GetInt32());
                    continue;
                }
                if (property.NameEquals("iconCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    iconCode = new IconCode(property.Value.GetInt32());
                    continue;
                }
                if (property.NameEquals("iconPhrase"u8))
                {
                    iconPhrase = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("phrase"u8))
                {
                    phrase = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("temperature"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    temperature = WeatherValueRange.DeserializeWeatherValueRange(property.Value);
                    continue;
                }
                if (property.NameEquals("realFeelTemperature"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    realFeelTemperature = WeatherValueRange.DeserializeWeatherValueRange(property.Value);
                    continue;
                }
                if (property.NameEquals("dewPoint"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dewPoint = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("relativeHumidity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    relativeHumidity = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("wind"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    wind = WindDetails.DeserializeWindDetails(property.Value);
                    continue;
                }
                if (property.NameEquals("windGust"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    windGust = WindDetails.DeserializeWindDetails(property.Value);
                    continue;
                }
                if (property.NameEquals("visibility"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    visibility = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("cloudCover"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cloudCover = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("hasPrecipitation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hasPrecipitation = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("precipitationType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    precipitationType = new PrecipitationType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("precipitationIntensity"u8))
                {
                    precipitationIntensity = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("precipitationProbability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    precipitationProbability = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("thunderstormProbability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    thunderstormProbability = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("totalLiquid"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalLiquid = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("rain"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rain = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("snow"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    snow = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("ice"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ice = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
            }
            return new QuarterDayForecast(
                date,
                effectiveDate,
                quarter,
                iconCode,
                iconPhrase,
                phrase,
                temperature,
                realFeelTemperature,
                dewPoint,
                relativeHumidity,
                wind,
                windGust,
                visibility,
                cloudCover,
                hasPrecipitation,
                precipitationType,
                precipitationIntensity,
                precipitationProbability,
                thunderstormProbability,
                totalLiquid,
                rain,
                snow,
                ice);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static QuarterDayForecast FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeQuarterDayForecast(document.RootElement);
        }
    }
}
