// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Maps.Weather.Models
{
    /// <summary> The PressureTendency. </summary>
    public partial class PressureTendency
    {
        /// <summary> Initializes a new instance of <see cref="PressureTendency"/>. </summary>
        internal PressureTendency()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PressureTendency"/>. </summary>
        /// <param name="description"> Description of the pressure tendency in specified language. </param>
        /// <param name="code"> Pressure tendency code regardless of language. One of F=Falling, S=Steady, R=Rising. </param>
        internal PressureTendency(string description, string code)
        {
            Description = description;
            Code = code;
        }

        /// <summary> Description of the pressure tendency in specified language. </summary>
        public string Description { get; }
        /// <summary> Pressure tendency code regardless of language. One of F=Falling, S=Steady, R=Rising. </summary>
        public string Code { get; }
    }
}
