// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.Weather.Models
{
    public partial class PressureTendency
    {
        internal static PressureTendency DeserializePressureTendency(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string localizedDescription = default;
            string code = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("localizedDescription"u8))
                {
                    localizedDescription = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("code"u8))
                {
                    code = property.Value.GetString();
                    continue;
                }
            }
            return new PressureTendency(localizedDescription, code);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static PressureTendency FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializePressureTendency(document.RootElement);
        }
    }
}
