// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Weather.Models
{
    /// <summary> Specifies the type of precipitation ("Rain" "Snow" "Ice" or "Mix"). If dbz is zero, precipitationType is not present in the response. </summary>
    public readonly partial struct PrecipitationType : IEquatable<PrecipitationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PrecipitationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PrecipitationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RainValue = "Rain";
        private const string SnowValue = "Snow";
        private const string IceValue = "Ice";
        private const string MixValue = "Mix";

        /// <summary> Rain. </summary>
        public static PrecipitationType Rain { get; } = new PrecipitationType(RainValue);
        /// <summary> Snow. </summary>
        public static PrecipitationType Snow { get; } = new PrecipitationType(SnowValue);
        /// <summary> Ice. </summary>
        public static PrecipitationType Ice { get; } = new PrecipitationType(IceValue);
        /// <summary> Mix. </summary>
        public static PrecipitationType Mix { get; } = new PrecipitationType(MixValue);
        /// <summary> Determines if two <see cref="PrecipitationType"/> values are the same. </summary>
        public static bool operator ==(PrecipitationType left, PrecipitationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PrecipitationType"/> values are not the same. </summary>
        public static bool operator !=(PrecipitationType left, PrecipitationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PrecipitationType"/>. </summary>
        public static implicit operator PrecipitationType(string value) => new PrecipitationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PrecipitationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PrecipitationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
