// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Maps.Weather.Models
{
    /// <summary> The PrecipitationSummary. </summary>
    public partial class PrecipitationSummary
    {
        /// <summary> Initializes a new instance of <see cref="PrecipitationSummary"/>. </summary>
        internal PrecipitationSummary()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PrecipitationSummary"/>. </summary>
        /// <param name="pastHour"> The amount of precipitation (liquid equivalent) that has fallen in the past hour. </param>
        /// <param name="pastThreeHours"> The amount of precipitation (liquid equivalent) that has fallen in the past three hours. </param>
        /// <param name="pastSixHours"> The amount of precipitation (liquid equivalent) that has fallen in the past six hours. Contains Metric and Imperial Values. </param>
        /// <param name="pastNineHours"> The amount of precipitation (liquid equivalent) that has fallen in the past nine hours. </param>
        /// <param name="pastTwelveHours"> The amount of precipitation (liquid equivalent) that has fallen in the past 12 hours. </param>
        /// <param name="pastEighteenHours"> The amount of precipitation (liquid equivalent) that has fallen in the past 18 hours. </param>
        /// <param name="pastTwentyFourHours"> The amount of precipitation (liquid equivalent) that has fallen in the past 24 hours. </param>
        internal PrecipitationSummary(WeatherValue pastHour, WeatherValue pastThreeHours, WeatherValue pastSixHours, WeatherValue pastNineHours, WeatherValue pastTwelveHours, WeatherValue pastEighteenHours, WeatherValue pastTwentyFourHours)
        {
            PastHour = pastHour;
            PastThreeHours = pastThreeHours;
            PastSixHours = pastSixHours;
            PastNineHours = pastNineHours;
            PastTwelveHours = pastTwelveHours;
            PastEighteenHours = pastEighteenHours;
            PastTwentyFourHours = pastTwentyFourHours;
        }

        /// <summary> The amount of precipitation (liquid equivalent) that has fallen in the past hour. </summary>
        public WeatherValue PastHour { get; }
        /// <summary> The amount of precipitation (liquid equivalent) that has fallen in the past three hours. </summary>
        public WeatherValue PastThreeHours { get; }
        /// <summary> The amount of precipitation (liquid equivalent) that has fallen in the past six hours. Contains Metric and Imperial Values. </summary>
        public WeatherValue PastSixHours { get; }
        /// <summary> The amount of precipitation (liquid equivalent) that has fallen in the past nine hours. </summary>
        public WeatherValue PastNineHours { get; }
        /// <summary> The amount of precipitation (liquid equivalent) that has fallen in the past 12 hours. </summary>
        public WeatherValue PastTwelveHours { get; }
        /// <summary> The amount of precipitation (liquid equivalent) that has fallen in the past 18 hours. </summary>
        public WeatherValue PastEighteenHours { get; }
        /// <summary> The amount of precipitation (liquid equivalent) that has fallen in the past 24 hours. </summary>
        public WeatherValue PastTwentyFourHours { get; }
    }
}
