// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.Weather.Models
{
    public partial class PrecipitationSummary
    {
        internal static PrecipitationSummary DeserializePrecipitationSummary(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            WeatherValue pastHour = default;
            WeatherValue pastThreeHours = default;
            WeatherValue pastSixHours = default;
            WeatherValue pastNineHours = default;
            WeatherValue pastTwelveHours = default;
            WeatherValue pastEighteenHours = default;
            WeatherValue pastTwentyFourHours = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("pastHour"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pastHour = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("pastThreeHours"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pastThreeHours = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("pastSixHours"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pastSixHours = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("pastNineHours"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pastNineHours = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("pastTwelveHours"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pastTwelveHours = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("pastEighteenHours"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pastEighteenHours = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("pastTwentyFourHours"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pastTwentyFourHours = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
            }
            return new PrecipitationSummary(
                pastHour,
                pastThreeHours,
                pastSixHours,
                pastNineHours,
                pastTwelveHours,
                pastEighteenHours,
                pastTwentyFourHours);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static PrecipitationSummary FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializePrecipitationSummary(document.RootElement);
        }
    }
}
