// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Weather.Models
{
    /// <summary> Type of pollutant. Please note that more may be added at any time. </summary>
    public readonly partial struct PollutantType : IEquatable<PollutantType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PollutantType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PollutantType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string COValue = "CO";
        private const string NO2Value = "NO2";
        private const string O3Value = "O3";
        private const string PM25Value = "PM2.5";
        private const string PM10Value = "PM10";
        private const string SO2Value = "SO2";

        /// <summary> Carbon monoxide ("CO"). </summary>
        public static PollutantType CO { get; } = new PollutantType(COValue);
        /// <summary> Nitrogen dioxide ("NO2"). </summary>
        public static PollutantType NO2 { get; } = new PollutantType(NO2Value);
        /// <summary> Ozone ("O3"). </summary>
        public static PollutantType O3 { get; } = new PollutantType(O3Value);
        /// <summary> Particulate matter 2.5 ("PM2.5"). </summary>
        public static PollutantType PM25 { get; } = new PollutantType(PM25Value);
        /// <summary> Particulate matter 10 ("PM10"). </summary>
        public static PollutantType PM10 { get; } = new PollutantType(PM10Value);
        /// <summary> Sulfur dioxide ("SO2"). </summary>
        public static PollutantType SO2 { get; } = new PollutantType(SO2Value);
        /// <summary> Determines if two <see cref="PollutantType"/> values are the same. </summary>
        public static bool operator ==(PollutantType left, PollutantType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PollutantType"/> values are not the same. </summary>
        public static bool operator !=(PollutantType left, PollutantType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PollutantType"/>. </summary>
        public static implicit operator PollutantType(string value) => new PollutantType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PollutantType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PollutantType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
