// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.Weather.Models
{
    public partial class Pollutant
    {
        internal static Pollutant DeserializePollutant(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            PollutantType? type = default;
            string name = default;
            float? index = default;
            float? globalIndex = default;
            WeatherValue concentration = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("type"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    type = new PollutantType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("index"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    index = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("globalIndex"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    globalIndex = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("concentration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    concentration = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
            }
            return new Pollutant(type, name, index, globalIndex, concentration);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static Pollutant FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializePollutant(document.RootElement);
        }
    }
}
