// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    /// <summary> The MinuteForecastResult. </summary>
    public partial class MinuteForecastResult
    {
        /// <summary> Initializes a new instance of <see cref="MinuteForecastResult"/>. </summary>
        internal MinuteForecastResult()
        {
            IntervalSummaries = new ChangeTrackingList<IntervalSummary>();
            Intervals = new ChangeTrackingList<ForecastInterval>();
        }

        /// <summary> Initializes a new instance of <see cref="MinuteForecastResult"/>. </summary>
        /// <param name="summary"> Phrase summaries for the entire forecast period. </param>
        /// <param name="intervalSummaries"> Summary information for each interval in the forecast. The Summaries breaks down each potential interval where precipitation starts and stops. </param>
        /// <param name="intervals"> Forecast data for each interval in the forecast. </param>
        internal MinuteForecastResult(MinuteForecastSummary summary, IReadOnlyList<IntervalSummary> intervalSummaries, IReadOnlyList<ForecastInterval> intervals)
        {
            Summary = summary;
            IntervalSummaries = intervalSummaries;
            Intervals = intervals;
        }

        /// <summary> Phrase summaries for the entire forecast period. </summary>
        public MinuteForecastSummary Summary { get; }
        /// <summary> Summary information for each interval in the forecast. The Summaries breaks down each potential interval where precipitation starts and stops. </summary>
        public IReadOnlyList<IntervalSummary> IntervalSummaries { get; }
        /// <summary> Forecast data for each interval in the forecast. </summary>
        public IReadOnlyList<ForecastInterval> Intervals { get; }
    }
}
