// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class MinuteForecastResult
    {
        internal static MinuteForecastResult DeserializeMinuteForecastResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            MinuteForecastSummary summary = default;
            IReadOnlyList<IntervalSummary> intervalSummaries = default;
            IReadOnlyList<ForecastInterval> intervals = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("summary"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    summary = MinuteForecastSummary.DeserializeMinuteForecastSummary(property.Value);
                    continue;
                }
                if (property.NameEquals("intervalSummaries"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<IntervalSummary> array = new List<IntervalSummary>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(IntervalSummary.DeserializeIntervalSummary(item));
                    }
                    intervalSummaries = array;
                    continue;
                }
                if (property.NameEquals("intervals"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ForecastInterval> array = new List<ForecastInterval>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ForecastInterval.DeserializeForecastInterval(item));
                    }
                    intervals = array;
                    continue;
                }
            }
            return new MinuteForecastResult(summary, intervalSummaries ?? new ChangeTrackingList<IntervalSummary>(), intervals ?? new ChangeTrackingList<ForecastInterval>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MinuteForecastResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMinuteForecastResult(document.RootElement);
        }
    }
}
