// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Maps.Weather.Models
{
    /// <summary> Local weather data provider information. </summary>
    public partial class LocalSource
    {
        /// <summary> Initializes a new instance of <see cref="LocalSource"/>. </summary>
        internal LocalSource()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LocalSource"/>. </summary>
        /// <param name="id"> Numeric identifier, unique to the local data provider. </param>
        /// <param name="name"> Name of the local data provider. Name is displayed in the language specified by language code in URL, if available. Otherwise, Name is displayed in English or the language in which the name was provided. </param>
        /// <param name="weatherCode"> Weather code provided by the local data provider. This weather code allows the forecast to be matched to icons provided by the local data provider instead of Azure Maps icons. </param>
        internal LocalSource(int? id, string name, string weatherCode)
        {
            Id = id;
            Name = name;
            WeatherCode = weatherCode;
        }

        /// <summary> Numeric identifier, unique to the local data provider. </summary>
        public int? Id { get; }
        /// <summary> Name of the local data provider. Name is displayed in the language specified by language code in URL, if available. Otherwise, Name is displayed in English or the language in which the name was provided. </summary>
        public string Name { get; }
        /// <summary> Weather code provided by the local data provider. This weather code allows the forecast to be matched to icons provided by the local data provider instead of Azure Maps icons. </summary>
        public string WeatherCode { get; }
    }
}
