// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Weather.Models
{
    /// <summary> Keyword for the latest status of the alert. </summary>
    public readonly partial struct LatestStatusKeyword : IEquatable<LatestStatusKeyword>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LatestStatusKeyword"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LatestStatusKeyword(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NewValue = "New";
        private const string ExtendValue = "Extend";
        private const string CancelValue = "Cancel";
        private const string CorrectValue = "Correct";
        private const string ExpireValue = "Expire";
        private const string UpgradeValue = "Upgrade";
        private const string ContinueValue = "Continue";
        private const string UpdateValue = "Update";

        /// <summary> "New" - the status of an alert upon initial issuance. </summary>
        public static LatestStatusKeyword New { get; } = new LatestStatusKeyword(NewValue);
        /// <summary> "Extend" - the alert has been extended in time, in area, or both since its initial issuance. </summary>
        public static LatestStatusKeyword Extend { get; } = new LatestStatusKeyword(ExtendValue);
        /// <summary> "Cancel" - the alert has been canceled prior to its original expiration time. </summary>
        public static LatestStatusKeyword Cancel { get; } = new LatestStatusKeyword(CancelValue);
        /// <summary> "Correct" - the alert has been modified to correct a previous error. </summary>
        public static LatestStatusKeyword Correct { get; } = new LatestStatusKeyword(CorrectValue);
        /// <summary> "Expire" - the alert has expired and is no longer active. </summary>
        public static LatestStatusKeyword Expire { get; } = new LatestStatusKeyword(ExpireValue);
        /// <summary> "Upgrade" - the alert has been upgraded to a higher class or category since its initial issuance. </summary>
        public static LatestStatusKeyword Upgrade { get; } = new LatestStatusKeyword(UpgradeValue);
        /// <summary> "Continue" - the alert has been updated since its initial issuance, but no changes were made to `alertDetails`, `startTime`, `endTime`, or `class`. </summary>
        public static LatestStatusKeyword Continue { get; } = new LatestStatusKeyword(ContinueValue);
        /// <summary> "Update" - the alert has been updated since its initial issuance. </summary>
        public static LatestStatusKeyword Update { get; } = new LatestStatusKeyword(UpdateValue);
        /// <summary> Determines if two <see cref="LatestStatusKeyword"/> values are the same. </summary>
        public static bool operator ==(LatestStatusKeyword left, LatestStatusKeyword right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LatestStatusKeyword"/> values are not the same. </summary>
        public static bool operator !=(LatestStatusKeyword left, LatestStatusKeyword right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LatestStatusKeyword"/>. </summary>
        public static implicit operator LatestStatusKeyword(string value) => new LatestStatusKeyword(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LatestStatusKeyword other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LatestStatusKeyword other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
